# ========================================================================================================
#   Assetto Corsa acCoach v1.0.1.3
#
#   - written by IMedia -=|SOUKANABIS|=- Juil 2020
#       rev: 22.04.2021; rev: 25.04.2021; 02.05.2021
#
#   - contact: contact@veydunet.com
#
#   The acCoach package can be downloaded at: https:\\veydunet.com
#  
#   credit: Graphic Mirror custom is Original idea by David Zahn (c) 2017
# ========================================================================================================

import os
import sys
import platform
import ac
import acsys
import math
import subprocess
import io
import time

if platform.architecture()[0] == "64bit":
    sys.path.insert(0, "apps/python/acCoach/stdlib64")
else:
    sys.path.insert(0, "apps/python/acCoach/stdlib")
os.environ['PATH'] = os.environ['PATH'] + ";."

from sim_info import info
import socket
import configparser

appWindow=0
gearsWindow=0
speedWindow=0
retroWindow=0
speakWindow=0
appWindowIsActive = False

ip_address_conn=""
vlabel_LapCount=0
vlabel_LapTime=0
vlabel_BestLap=0
vlabel_LastLap=0
vlabel_LapTimeTxt=0
vlabel_BestLapTxt=0
vlabel_LastLapTxt=0
vlabel_Position=0
vlabel_ComparResult=""
vLabel_Gears=0
customFont = "Ticking Timebomb BB"
vCompar_A=0
vCompar_B=0
vCompar_C=0
visInPit=0
vendRace=0
vstatusFlags=0
vpolePosition=0
vpracticeRace=0
vqualifyRace=0
vstartRace=0
vdrsAvailable=0
vdrsEnable=0
vTyresOut=0
vCycle=0
vVerifyPos=1 
lastGear = "N"
numphraseFlags=0
numphraseValide=0
nombreInvalide=0
speedMAX=0

PHRASE_1=""
PHRASE_2=""
PHRASE_3=""
PHRASE_4=""
PHRASE_5=""
PHRASE_6=""
PHRASE_7=""
PHRASE_8=""
PHRASE_9=""
PHRASE_10=""
PHRASE_11=""
PHRASE_12=""
PHRASE_13=""
PHRASE_14=""
PHRASE_15=""
PHRASE_16=""
PHRASE_17=""
PHRASE_18=""
PHRASE_19=""
PHRASE_20=""
PHRASE_21=""
PHRASE_22=""
PHRASE_23=""
PHRASE_24=""
PHRASE_25=""
PHRASE_26=""
PHRASE_27=""
PHRASE_28=""
PHRASE_29=""

colors = {
            "white"      : [255, 255, 255],
            "yellow"     : [255, 255,   0],
            "green"      : [0,   255,   0],
            "red"        : [250,  0,    0],
            "orange"     : [255, 128,   0],
            "azure"      : [50,  100, 150],
            "purple"     : [238, 130, 238],
            "cyan"       : [0,   255, 255],
            "magenta"    : [255,   0, 255],
            "grey"       : [128, 128, 128],
            "blue"       : [77, 77,   255],
            "vert"       : [0,   153,   0],
            "black"      : [0,     0,   0],
            "grad_0"     : [180,  105,  0], 
            "grad_1"     : [185,  120,  0],
            "grad_2"     : [190,  135,  0], 
            "grad_3"     : [195,  150,  0],
            "grad_4"     : [200,  165,  0],
            "grad_5"     : [205,  180,  0], 
            "grad_6"     : [210,  195,  0], 
            "grad_7"     : [215,  205,  0], 
            "grad_8"     : [220,  220,  0],
            "grad_9"     : [225,  235,  0],
            "grad_10"    : [230,  250,  0],
            "grad_11"    : [235,  255,  0],
            "grad_12"    : [240,  255,  0], 
            "grad_13"    : [245,  255,  0],
            "grad_14"    : [250,  255,  0],
            "grad_15"    : [255,  255,  0],
         }

def acMain(ac_version):
    global appWindow, gearsWindow, speedWindow, retroWindow, speakWindow, vVerifyPos

    appWindow = ac.newApp("acCoach")
    gearsWindow = ac.newApp("acCoachgears")
    speedWindow = ac.newApp("acCoachspeed")
    retroWindow = ac.newApp("acCoachretro")
    speakWindow = ac.newApp("acCoachspeak")

    ac.setTitle(appWindow, "")
    ac.setSize(appWindow,300,250)
    ac.drawBorder(appWindow,0)
    ac.setIconPosition(appWindow, 0, -10000)
    ac.drawBackground(appWindow,0)
    ac.setBackgroundOpacity(appWindow,0)

    ac.setTitle(speakWindow, "")
    ac.setSize(speakWindow,150,100)
    ac.drawBorder(speakWindow,0)
    ac.setIconPosition(speakWindow, 0, -10000)
    ac.drawBackground(speakWindow,0)
    ac.setBackgroundOpacity(speakWindow,0)

    ac.setTitle(gearsWindow, "")
    ac.setSize(gearsWindow,150,100)
    ac.drawBorder(gearsWindow,0)
    ac.setIconPosition(gearsWindow, 0, -10000)
    ac.drawBackground(gearsWindow,0)
    ac.setBackgroundOpacity(gearsWindow,0)

    ac.setTitle(speedWindow, "")
    ac.setSize(speedWindow,150,100)
    ac.drawBorder(speedWindow,0)
    ac.setIconPosition(speedWindow, 0, -10000)
    ac.drawBackground(speedWindow,0)
    ac.setBackgroundOpacity(speedWindow,0)
    
    ac.setTitle(retroWindow, "")
    ac.setSize(retroWindow,549,340)
    ac.drawBorder(retroWindow,0)
    ac.setIconPosition(retroWindow, 0, -10000)
    ac.drawBackground(retroWindow,0)
    ac.setBackgroundOpacity(retroWindow,0)
    ac.setPosition(retroWindow, 684, -85) 
    ac.setBackgroundTexture(retroWindow, "apps/python/acCoach/img/retro.png")

    start_speak_btn = ac.addButton(speakWindow, "")
    ac.setSize(start_speak_btn, 24, 24)
    ac.setPosition(start_speak_btn, 10, 30)
    ac.setBackgroundTexture(start_speak_btn, "apps/python/acCoach/img/ON_BTN.png")

    stop_speak_btn = ac.addButton(speakWindow, "")
    ac.setSize(stop_speak_btn, 24, 24)
    ac.setPosition(stop_speak_btn, 40, 30)
    ac.setBackgroundTexture(stop_speak_btn, "apps/python/acCoach/img/OFF_BTN.png")

    ac.addOnClickedListener(start_speak_btn, StartspeakHandler)
    ac.addOnClickedListener(stop_speak_btn, StopspeakHandler)

    LoadMainapp()
    cnfLoad(0, 0);
    
    ac.addOnAppActivatedListener(appWindow, onAppWindowActivated)
    ac.addOnAppDismissedListener(appWindow, onAppWindowDismissed)

    return "acCoach"

def LoadMainapp():
    global appWindow, gearsWindow, speedWindow, customFont, colors, vlabel_Position, vlabel_LapCount, vlabel_numberOfLaps, vlabel_LapTimeTxt, vlabel_BestLapTxt, vlabel_LastLapTxt, vlabel_LapTime, vlabel_BestLap, vlabel_LastLap, vCompar_A, vCompar_B, vlabel_ComparResult, vLabel_Gears, vLabel_Speed 

    ac.initFont(0, customFont, 0, 0)

    vlabel_Position = ac.addLabel(appWindow, "0");
    vlabel_LapCount = ac.addLabel(appWindow, "Laps: 0");
    vlabel_LapTimeTxt = ac.addLabel(appWindow, "Lap : ");
    vlabel_BestLapTxt = ac.addLabel(appWindow, "Best: ");
    vlabel_LastLapTxt = ac.addLabel(appWindow, "Last: ");    
    vlabel_LapTime = ac.addLabel(appWindow, "-- : -- . ---");
    vlabel_BestLap = ac.addLabel(appWindow, "-- : -- . ---");
    vlabel_LastLap = ac.addLabel(appWindow, "-- : -- . ---");
    vlabel_ComparResult = ac.addLabel(appWindow, "");

    ac.setPosition(vlabel_Position, 10, 30)
    ac.setPosition(vlabel_LapCount, 110, 65)
    ac.setPosition(vlabel_LapTimeTxt, 3, 120)
    ac.setPosition(vlabel_BestLapTxt, 3, 150) 
    ac.setPosition(vlabel_LastLapTxt, 3, 180)
    ac.setPosition(vlabel_LapTime, 50, 120)
    ac.setPosition(vlabel_BestLap, 50, 150) 
    ac.setPosition(vlabel_LastLap, 50, 180)
    ac.setPosition(vlabel_ComparResult, 3, 210)

    ac.setFontSize(vlabel_Position, 60)
    ac.setFontSize(vlabel_LapCount, 20)
    ac.setFontSize(vlabel_LapTimeTxt, 18)    
    ac.setFontSize(vlabel_BestLapTxt, 18)
    ac.setFontSize(vlabel_LastLapTxt, 18)    
    ac.setFontSize(vlabel_LapTime, 30)    
    ac.setFontSize(vlabel_BestLap, 30)
    ac.setFontSize(vlabel_LastLap, 30)
    ac.setFontSize(vlabel_ComparResult, 18)

    ac.setCustomFont(vlabel_Position, "Verdana", 1, 1)
    ac.setCustomFont(vlabel_LapCount, "Verdana", 1, 1)
    ac.setCustomFont(vlabel_LapTimeTxt, "Verdana", 0, 1)
    ac.setCustomFont(vlabel_BestLapTxt, "Verdana", 0, 1)
    ac.setCustomFont(vlabel_LastLapTxt, "Verdana", 0, 1)    
    ac.setCustomFont(vlabel_LapTime, customFont, 0, 0)
    ac.setCustomFont(vlabel_BestLap, customFont, 0, 0)
    ac.setCustomFont(vlabel_LastLap, customFont, 0, 0)
    ac.setCustomFont(vlabel_ComparResult, "Verdana", 0, 0) 

    ac.setFontColor(vlabel_Position, *rgb(colors["blue"]))
    ac.setFontColor(vlabel_LapTime, *rgb(colors["vert"]))
    ac.setFontColor(vlabel_BestLap, *rgb(colors["magenta"]))
    ac.setFontColor(vlabel_LastLap, *rgb(colors["orange"]))
    ac.setFontColor(vlabel_LapTimeTxt, *rgb(colors["vert"]))
    ac.setFontColor(vlabel_BestLapTxt, *rgb(colors["magenta"]))
    ac.setFontColor(vlabel_LastLapTxt, *rgb(colors["orange"]))

    vLabel_Gears = ac.addLabel(gearsWindow, "0");
    ac.setPosition(vLabel_Gears, 0, 0)
    ac.setFontSize(vLabel_Gears, 80)
    ac.setCustomFont(vLabel_Gears, customFont, 0, 0) 
    ac.setFontColor(vLabel_Gears, *rgb(colors["red"]))

    vLabel_Speed = ac.addLabel(speedWindow, "0");
    ac.setPosition(vLabel_Speed, 0, 0)
    ac.setFontSize(vLabel_Speed, 80)
    ac.setCustomFont(vLabel_Speed, customFont, 0, 0) 
    ac.setFontColor(vLabel_Speed, *rgb(colors["grad_0"]))               

def cnfLoad(v1, v2):
    global appWindow, ip_address_conn, PHRASE_1, PHRASE_2, PHRASE_3, PHRASE_4, PHRASE_5, PHRASE_6, PHRASE_7, PHRASE_8, PHRASE_9, PHRASE_10, PHRASE_11, PHRASE_12, PHRASE_13, PHRASE_14, PHRASE_15, PHRASE_16, PHRASE_17, PHRASE_18, PHRASE_19, PHRASE_20, PHRASE_21, PHRASE_22, PHRASE_23, PHRASE_24, PHRASE_25, PHRASE_26, PHRASE_27, PHRASE_28, PHRASE_29

    config = configparser.SafeConfigParser()
    config.read("apps/python/acCoach/config.ini", encoding='utf-8')

    ip_address_conn = config.get("accoah_config", "ip_address_connect")
    PHRASE_1 = config.get("accoah_config", "PHRASE_1")
    PHRASE_2 = config.get("accoah_config", "PHRASE_2")
    PHRASE_3 = config.get("accoah_config", "PHRASE_3")
    PHRASE_4 = config.get("accoah_config", "PHRASE_4")
    PHRASE_5 = config.get("accoah_config", "PHRASE_5")
    PHRASE_6 = config.get("accoah_config", "PHRASE_6")
    PHRASE_7 = config.get("accoah_config", "PHRASE_7")
    PHRASE_8 = config.get("accoah_config", "PHRASE_8")
    PHRASE_9 = config.get("accoah_config", "PHRASE_9")
    PHRASE_10 = config.get("accoah_config", "PHRASE_10")
    PHRASE_11 = config.get("accoah_config", "PHRASE_11")
    PHRASE_12 = config.get("accoah_config", "PHRASE_12")
    PHRASE_13 = config.get("accoah_config", "PHRASE_13")
    PHRASE_14 = config.get("accoah_config", "PHRASE_14")
    PHRASE_15 = config.get("accoah_config", "PHRASE_15")
    PHRASE_16 = config.get("accoah_config", "PHRASE_16")
    PHRASE_17 = config.get("accoah_config", "PHRASE_17")
    PHRASE_18 = config.get("accoah_config", "PHRASE_18")
    PHRASE_19 = config.get("accoah_config", "PHRASE_19")
    PHRASE_20 = config.get("accoah_config", "PHRASE_20")
    PHRASE_21 = config.get("accoah_config", "PHRASE_21")
    PHRASE_22 = config.get("accoah_config", "PHRASE_22")
    PHRASE_23 = config.get("accoah_config", "PHRASE_23")
    PHRASE_24 = config.get("accoah_config", "PHRASE_24")
    PHRASE_25 = config.get("accoah_config", "PHRASE_25")
    PHRASE_26 = config.get("accoah_config", "PHRASE_26")
    PHRASE_27 = config.get("accoah_config", "PHRASE_27")
    PHRASE_28 = config.get("accoah_config", "PHRASE_28")
    PHRASE_29 = config.get("accoah_config", "PHRASE_29")

def acUpdate(deltaT):
    global appWindow, speakWindow, gearsWindow, retroWindow, speedWindow, vVerifyPos

    ac.setBackgroundOpacity(appWindow,0)
    ac.setBackgroundOpacity(speakWindow,0)
    ac.setBackgroundOpacity(gearsWindow,0)
    ac.setBackgroundOpacity(retroWindow,0)
    ac.setBackgroundOpacity(speedWindow,0)

    startRaceHandler(deltaT)
    positionHandler(deltaT)
    timelapsHandler(deltaT)
    gearsHandler(deltaT)
    pitstopHandler(deltaT)      
    endRaceHandler(deltaT)
    polePositionHandler(deltaT)
    statusFlagsHandler(deltaT)
    speedKMH(deltaT) 
    valideLapHandler(deltaT)

def positionHandler(deltaT):
    global appWindow, vlabel_Position, vVerifyPos

    val_Position = ac.getCarRealTimeLeaderboardPosition(0)

    if vVerifyPos != val_Position:
        vVerifyPos = val_Position
        ac.setText(vlabel_Position, "{}".format(val_Position+1))

    if  ac.getCarState(0, acsys.CS.RaceFinished) == 1 and info.graphics.session == 2:
        val_Position = ac.getCarLeaderboardPosition(0)
        ac.setText(vlabel_Position, "{}".format(val_Position))

def timelapsHandler(deltaT):
    global appWindow, visInPit, vCycle, vlabel_LapCount, vlabel_LapTime, vlabel_BestLap, vlabel_LastLap, vCompar_A, vCompar_B, vCompar_C, vlabel_ComparResult, speedMAX, numphraseValide

    val_LapCount = ac.getCarState(0, acsys.CS.LapCount)

    val_numberOfLaps = int(info.graphics.numberOfLaps)
    
    val_BestLap = ac.getCarState(0, acsys.CS.BestLap)  
    vCompar_A=val_BestLap 
    ac.setText(vlabel_BestLap, formatTime(val_BestLap) if int(val_BestLap) != 0 else "-- : -- . ---")

    val_LastLap = ac.getCarState(0, acsys.CS.LastLap)
    vCompar_B=val_LastLap
    ac.setText(vlabel_LastLap, formatTime(val_LastLap) if int(val_LastLap) != 0 else "-- : -- . ---")    

    if vCompar_B == vCompar_A and vCompar_C != val_LapCount:
        ac.setText(vlabel_ComparResult, "Yes")
        ac.setFontColor(vlabel_ComparResult, *rgb(colors["vert"]))
        SenddataServ(PHRASE_1)                     
    elif vCompar_B < vCompar_A and vCompar_C != val_LapCount:
        ac.setText(vlabel_ComparResult, "Yes")
        ac.setFontColor(vlabel_ComparResult, *rgb(colors["vert"]))
        SenddataServ(PHRASE_1)          

    if vCompar_A != vCompar_B and vCompar_C != val_LapCount:
        ac.setText(vlabel_ComparResult, "No")
        ac.setFontColor(vlabel_ComparResult, *rgb(colors["red"]))
        SenddataServ(PHRASE_2) 

    if val_numberOfLaps == 0:
        val_numberOfLaps = val_LapCount

    if vCompar_C != val_LapCount:
        ac.setFontColor(vlabel_LapTime, *rgb(colors["vert"]))
        SenddataServ("{}{}{}{}{}{}{}".format(PHRASE_3, val_LapCount, PHRASE_4, val_numberOfLaps, PHRASE_28, speedMAX, PHRASE_29))          
        vCompar_C = val_LapCount
        numphraseValide = 0
    else:
        vCompar_C = vCompar_C

    if  val_LapCount == val_numberOfLaps -1 and vCycle == 0:
        vCycle = 1
        SenddataServ(PHRASE_5)

    ac.setText(vlabel_LapCount, "Laps: {} / {}".format(val_LapCount +1, val_numberOfLaps))

    val_LapTime = ac.getCarState(0, acsys.CS.LapTime)    
    ac.setText(vlabel_LapTime, formatTime(val_LapTime) if int(val_LapTime) != 0 else "-- : -- . ---")

def valideLapHandler(deltaT):
    global vTyresOut, numphraseValide, nombreInvalide

    if info.physics.numberOfTyresOut > 2 and vTyresOut == 0:
        vTyresOut = 1        
        numphraseValide += 1
        nombreInvalide += 1
        speekMultipleValide(numphraseValide)
        ac.setFontColor(vlabel_LapTime, *rgb(colors["red"]))
    elif info.physics.numberOfTyresOut < 3:
        vTyresOut = 0       

def speekMultipleValide(numtext):
    global numphraseValide

    if numtext > 4:
        numtext = 0
        numphraseValide = 0

    if numtext == 1:
        SenddataServ(PHRASE_6)            
    elif numtext == 2:
        SenddataServ(PHRASE_7)
    elif numtext == 3:        
        SenddataServ(PHRASE_8) 
    elif numtext == 4:        
        SenddataServ(PHRASE_9)      

def pitstopHandler(deltaT):
    global visInPit, nombreInvalide, speedMAX

    pitstop = int(info.graphics.isInPit)  
    distanceT = int(info.graphics.distanceTraveled)   

    if pitstop == 1 and visInPit == 0:
        visInPit = 1
        SenddataServ("{}{}{}{}{}{}{}{}{}".format(PHRASE_10, distanceT, PHRASE_11, PHRASE_26, nombreInvalide, PHRASE_27, PHRASE_28, speedMAX, PHRASE_29))
        ac.setFontColor(vlabel_LapTime, *rgb(colors["vert"]))
        nombreInvalide = 0
    elif pitstop != 1 and visInPit == 1:  
        visInPit = 0 

def polePositionHandler(deltaT):
    global vpolePosition

    if info.graphics.session == 1 and info.graphics.position == 1 and vpolePosition == 0:
        vpolePosition = 1
        SenddataServ(PHRASE_12)
    elif info.graphics.session == 1 and info.graphics.position != 1 and vpolePosition == 1:
        vpolePosition = 0

def startRaceHandler(deltaT):
    global vpracticeRace, vqualifyRace, vstartRace 

    val_Position = ac.getCarRealTimeLeaderboardPosition(0)

    if vpracticeRace == 0 and info.graphics.session == 0:
        vpracticeRace = 1
        SenddataServ(PHRASE_13)
    elif vpracticeRace == 1 and info.graphics.session != 0:
        vpracticeRace = 0

    if vqualifyRace == 0 and info.graphics.session == 1:
        vqualifyRace = 1
        SenddataServ(PHRASE_14)
    elif vqualifyRace == 1 and info.graphics.session != 1:
        vqualifyRace = 0

    if vstartRace == 0 and info.graphics.session == 2:
        vstartRace = 1
        SenddataServ("{}{}{}".format(PHRASE_15, val_Position +1, PHRASE_16))
    elif vstartRace == 1 and info.graphics.session != 2:
        vstartRace = 0 

def endRaceHandler(deltaT):
    global vendRace

    val_Position = ac.getCarLeaderboardPosition(0)

    if  ac.getCarState(0, acsys.CS.RaceFinished) == 1 and vendRace == 0 and info.graphics.session == 2:
        vendRace =  1
        SenddataServ("{}{}{}".format(PHRASE_17, val_Position, PHRASE_18))
    elif ac.getCarState(0, acsys.CS.RaceFinished) != 1 and vendRace == 1:
        vendRace = 0    

def speedKMH(deltaT):
    global vLabel_Speed, speedMAX

    val_kmh = int(info.physics.speedKmh)
    ac.setText(vLabel_Speed, "{}".format(val_kmh))

    if val_kmh > speedMAX:
        speedMAX = val_kmh

    if val_kmh > 25: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_1"]))
    if val_kmh > 50: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_2"]))
    if val_kmh > 75: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_3"]))
    if val_kmh > 100: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_4"]))
    if val_kmh > 125: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_5"]))
    if val_kmh > 150: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_6"]))
    if val_kmh > 175: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_7"]))
    if val_kmh > 200: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_8"]))
    if val_kmh > 225: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_9"]))
    if val_kmh > 250: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_10"]))
    if val_kmh > 275: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_11"]))
    if val_kmh > 300: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_12"]))
    if val_kmh > 325: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_13"]))
    if val_kmh > 350: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_14"]))
    if val_kmh > 375: ac.setFontColor(vLabel_Speed, *rgb(colors["grad_15"]))

def gearsHandler(deltaT):
    global vLabel_Gears

    val_gears = int(info.physics.gear)
    setGear = formatGears(val_gears)
    ac.setText(vLabel_Gears, setGear)

def formatGears(Gear):
    strGear = "%d" % (Gear - 1)
    if Gear == 0:
        strGear = "R"
    elif Gear == 1:
        strGear = "N"

    return strGear

def drsHandler(deltaT):
    global vdrsAvailable, vdrsEnable

    if ac.getCarState(0, acsys.CS.DrsAvailable) == 1 and vdrsAvailable == 0:
        vdrsAvailable = 1
        SenddataServ(PHRASE_19)
    elif ac.getCarState(0, acsys.CS.DrsAvailable) != 1 and vdrsAvailable == 1:
        vdrsAvailable == 0   

    if ac.getCarState(0, acsys.CS.DrsEnabled) == 1 and vdrsEnable == 0:
        vdrsEnable = 1
        SenddataServ(PHRASE_20)
    elif ac.getCarState(0, acsys.CS.DrsEnabled) != 1 and vdrsEnable == 1:
        vdrsAvailable == 0        

def statusFlagsHandler(deltaT):
    global vstatusFlags, numphraseFlags  

    if info.graphics.flag == 2 and vstatusFlags == 0:
        vstatusFlags = 1
        numphraseFlags += 1
        speekMultipleFlags(numphraseFlags)
    elif info.graphics.flag != 2 and vstatusFlags == 1:
        vstatusFlags = 0

def speekMultipleFlags(numtext):
    global numphraseFlags

    if numtext > 4:
        numtext = 0
        numphraseFlags = 0

    if numtext == 1:
        SenddataServ(PHRASE_21)            
    elif numtext == 2:
        SenddataServ(PHRASE_22)
    elif numtext == 3:        
        SenddataServ(PHRASE_23) 
    elif numtext == 4:        
        SenddataServ(PHRASE_24)           

def StartspeakHandler(*args):
    subprocess.call(["start", "/MIN", "", "apps/python/acCoach/acCoachT.exe", "Local"], shell=True)

def StopspeakHandler(*args):
    with open("closeac.txt", "w") as f:
        SenddataServ(PHRASE_25)
        SenddataServ("exit")              

def SenddataServ(dataSend):
    global ip_address_conn

    msgFromClient       = dataSend
    bytesToSend         = str.encode(msgFromClient)
    serverAddressPort   = (ip_address_conn, 11000)
    bufferSize          = 1024

    UDPClientSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
    UDPClientSocket.sendto(bytesToSend, serverAddressPort)

def onAppWindowActivated(*args):
    global appWindowIsActive
    appWindowIsActive = True  

def onAppWindowDismissed(*args):
    global appWindowIsActive
    appWindowIsActive = False           
  
def timeToMinSecMsecTuple(t):
    mins = t // (60*1000)
    secs = (t - 60*1000*mins) // 1000
    msecs = (t - 60*1000*mins - secs*1000)
    return mins, secs, msecs
    
def formatTime(t):
    mins, secs, msecs = timeToMinSecMsecTuple(abs(t))
    time = "%02d:%02d.%03d" % (mins, secs, msecs)
    return time
    mins, secs, msecs = timeToMinSecMsecTuple(abs(t))
    time = "%02d:%02d.%03d" % (mins, secs, msecs)
    return time

def rgb(color, a=1, bg=False):
    r = color[0] / 255
    g = color[1] / 255
    b = color[2] / 255
    return (r, g, b, a) if not bg else (r, g, b)  

def ErrorLogWrite(message):
    with io.open("apps/python/acCoach/Error.log","a", encoding='utf-8') as f:
        f.write("{} \n".format(message)) 
        f.close()      